CREATE OR REPLACE FUNCTION MADGIS.PLAN_IFRAZ_APPROVED(ORDERNO NUMBER) RETURN VARCHAR2
IS
ptype Number;
pno Varchar2(15);
gpno Varchar2(15);
prtno Varchar2(15);
gprtno Varchar2(15);
stno number;
n number;
muniq number;

BEGIN

FOR row IN (SELECT PLANTYP,PLANNO,PARTNO FROM MADCAP.LNDT4700 WHERE ID=ORDERNO)
   LOOP
       
       ptype:= row.PLANTYP;
       pno:=  row.PLANNO;
       prtno:=  row.PARTNO;
       
       select GPLANNO into gpno from MADCAP.LNDT3010 where PLANTYP=ptype and PLANNO=pno;
       gprtno:=MADCAP.BREAK_PARTNO2(prtno,1);
       stno:= MADCAP.BREAK_PARTNO2(prtno,2);
       
       if nvl(stno,0)=0  then
         select count(*) into n from PARCEL where PLAN_NO=gpno and PLAN_TYPE=ptype and PARCELNO = gprtno;
       else
         select count(*) into n from PARCEL where PLAN_NO=gpno and PLAN_TYPE=ptype and PARCELNO = gprtno and STR_NO=stno;
       end if; 
       
       if n=0 then
        return '-1';
       end if;
   
       if n>1 then
        return '-2';
       end if;
    
   
   
   END LOOP;


FOR row IN (SELECT UNIQUE_ID_4010 FROM MADCAP.LNDT4700_4010 WHERE LNDT4700_ID=ORDERNO)
   LOOP

       muniq:= row.UNIQUE_ID_4010;
       

       select count(*) into n from PARCEL_IFRAZ where PARCELCODE=muniq;
       
       if n=0 then
        return '-3';
       end if;
    
       if n>1 then
        return '-4';
       end if;
   
   
   END LOOP;


FOR row IN (SELECT PLANTYP,PLANNO,PARTNO FROM MADCAP.LNDT4700 WHERE ID=ORDERNO)
   LOOP
     
       ptype:= row.PLANTYP;
       pno:=  row.PLANNO;
       prtno:=  row.PARTNO;
       
       select GPLANNO into gpno from MADCAP.LNDT3010 where PLANTYP=ptype and PLANNO=pno;
       gprtno:=MADCAP.BREAK_PARTNO2(prtno,1);
       stno:=MADCAP.BREAK_PARTNO2(prtno,2);
       if nvl(stno,0)=0 then
           
           INSERT INTO PARCEL_IFRAZ_HISTORY (
            PARCELNO,PLAN_NAME,PLAN_NO,PLAN_TYPE,LAND_USE,RASTERNAME,B_NO,STR_NO,REMARKS,LEVEL_STATUS,N_STR_LEVEL,S_STR_LEVEL,
            E_STR_LEVEL,W_STR_LEVEL,ORDRNO,LICNO,LIC_STATUS,LUSE_CODE,MI_STYLE, MI_PRINX, GEOLOC) 
            Select PARCELNO, PLAN_NAME ,PLAN_NO,PLAN_TYPE,LAND_USE,RASTERNAME,B_NO,STR_NO,REMARKS,
             LEVEL_STATUS,N_STR_LEVEL,S_STR_LEVEL,E_STR_LEVEL,W_STR_LEVEL,ORDRNO,LICNO,LIC_STATUS,LUSE_CODE,
             MI_STYLE,0,GEOLOC from PARCEL where PLAN_NO=gpno and PLAN_TYPE=ptype and PARCELNO = gprtno;
             delete from PARCEL Where  PLAN_NO=gpno and PLAN_TYPE=ptype and PARCELNO = gprtno;
      else
           INSERT INTO MADGIS.PARCEL_IFRAZ_HISTORY (
            PARCELNO,PLAN_NAME,PLAN_NO,PLAN_TYPE,LAND_USE,RASTERNAME,B_NO,STR_NO,REMARKS,LEVEL_STATUS,N_STR_LEVEL,S_STR_LEVEL,
            E_STR_LEVEL,W_STR_LEVEL,ORDRNO,LICNO,LIC_STATUS,LUSE_CODE,MI_STYLE, MI_PRINX, GEOLOC) 
            Select PARCELNO, PLAN_NAME ,PLAN_NO,PLAN_TYPE,LAND_USE,RASTERNAME,B_NO,STR_NO,REMARKS,
             LEVEL_STATUS,N_STR_LEVEL,S_STR_LEVEL,E_STR_LEVEL,W_STR_LEVEL,ORDRNO,LICNO,LIC_STATUS,LUSE_CODE,
             MI_STYLE,0,GEOLOC from PARCEL where PLAN_NO=gpno and PLAN_TYPE=ptype and PARCELNO = gprtno and STR_NO=stno;
              delete from PARCEL  where PLAN_NO=gpno and PLAN_TYPE=ptype and PARCELNO = gprtno and STR_NO=stno;
       end if; 
       
    
   END LOOP;


FOR row IN (SELECT UNIQUE_ID_4010 FROM MADCAP.LNDT4700_4010 WHERE LNDT4700_ID=ORDERNO)
   LOOP
      
       muniq:= row.UNIQUE_ID_4010;
       
       select PLANTYP into ptype from MADCAP.LNDT4010 where UNIQUE_ID=muniq;
     select PLANNO into pno from MADCAP.LNDT4010 where UNIQUE_ID=muniq;
      select PARTNO into prtno from MADCAP.LNDT4010 where UNIQUE_ID=muniq;
      
   
       select GPLANNO into gpno from MADCAP.LNDT3010 where PLANTYP=ptype and PLANNO=pno;
       select MADCAP.BREAK_PARTNO2(prtno,1) into gprtno from dual;
       select MADCAP.BREAK_PARTNO2(prtno,2) into stno from dual;
       stno:=nvl(stno,0);
    
  INSERT INTO MADGIS.PARCEL (
            PARCELNO, PLAN_NO, 
            PLAN_TYPE,STR_NO, REMARKS, 
            MI_STYLE, MI_PRINX, GEOLOC) 
            Select gprtno, gpno ,ptype,stno ,'Ifraz ORDRNO=' ||ORDERNO,
            'Pen (2, 2, 255) Brush (1, 0, 16777215)',0,GEOLOC from PARCEL_IFRAZ where PARCELCODE=muniq;
   
   END LOOP;
   
   commit;
   
 return '1';

END PLAN_IFRAZ_APPROVED;
/